#version 330

uniform mat4 worldViewProj;
#ifdef _SOFT
uniform mat4 worldView;
uniform float farClip;
#endif

in vec4 vertex;
in vec4 colour;
in vec2 uv0;

out vec4 vcolor;
#ifdef _SOFT
out vec3 uv;
out vec4 clipPos;
#else
out vec2 uv;
#endif

void main()
{
	gl_Position = worldViewProj*vertex;
	vcolor = colour;
#ifdef _SOFT
	vec4 viewPos = worldView*vertex;
    uv = vec3(uv0.xy, viewPos.z/farClip);
	clipPos = gl_Position;
#else
    uv = uv0.xy;
#endif
}
